package ru.yandex.webmaster3.storage.util.ydb;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.storage.yql.YqlService;

/**
 * Created by Oleg Bazdyrev on 10/12/2020.
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class YdbYqlService {

    private final YqlService yqlService;

    @Value("${webmaster3.storage.ydb.dbname}")
    private String ydbDatabase;
    @Value("${webmaster3.storage.ydb.endpoint}")
    private String ydbEndpoint;

    public void importToYdb(String ydbTable, String yqlQuery, String yqlPrefix) {
        String importQuery = yqlPrefix + YdbUtils.getImportQueryString(ydbEndpoint, ydbDatabase, ydbTable, yqlQuery);
        yqlService.execute(importQuery);
    }

}
