package ru.yandex.webmaster3.storage.util.ydb.query;

import java.time.Duration;
import java.util.function.Function;

import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.Params;
import lombok.Value;

/**
 * @author kravchenko99
 * @date 11/16/21
 */

@Value
public class PreparedStatement {
    String querySql;
    String tableName;
    Statement.OperationType operationType;
    Duration timeout;
    Function<DataQuery, Params> paramsBuilder;

    public static PreparedStatement fromStatement(Statement st) {
        return new PreparedStatement(
                st.toQueryString(),
                st.table,
                st.operationType,
                st.timeout,
                st.paramsBuilder()
        );
    }

}
