package ru.yandex.webmaster3.storage.util.ydb.query;


import java.time.Duration;
import java.util.Map;
import java.util.function.Function;

import com.yandex.ydb.table.query.DataQuery;
import com.yandex.ydb.table.query.Params;
import com.yandex.ydb.table.values.Value;
import lombok.Setter;
import org.jetbrains.annotations.NotNull;

/**
 * ishalaru
 * 15.06.2020
 **/
public abstract class Statement {
    protected static final String TABLE_PREFIX = "PRAGMA TablePathPrefix = ";
    protected static final String SYNTAX_FIRST_VERSION = "--!syntax_v1";
    protected final String tablePrefix;
    protected final String table;
    protected final OperationType operationType;
    protected Duration timeout;

    @Setter
    protected boolean useFirstVersion = false;

    protected Statement(String tablePrefix,
                        String table,
                        OperationType operationType) {
        this.tablePrefix = tablePrefix;
        this.table = table;
        this.operationType = operationType;
    }

    public abstract String toQueryString();

    public abstract Map<String, Value> getParameters();

    public OperationType getOperationType() {
        return operationType;
    }



    @NotNull
    public Function<DataQuery, Params> paramsBuilder() {
        return query -> {
            Map<String, Value> paramsMap = getParameters();
            Params params = query.newParams();
            paramsMap.forEach(params::put);
            return params;
        };
    }

    public enum OperationType {
        SELECT,
        INSERT,
        UPSERT,
        BATCH_INSERT,
        BATCH_UPDATE,
        UPDATE,
        DELETE
    }

}
