package ru.yandex.webmaster3.storage.util.ydb.querybuilder;

import java.util.Collection;

import ru.yandex.webmaster3.storage.util.ydb.ExecuteQuery;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

/**
 * @author leonidrom
 */

/**
 * В отличии от BatchInsert, не обнуляет содержимое неуказанных колонок
 */
public class BatchUpdate<T> extends BaseBatch<T> {

    public BatchUpdate(String tablePrefix,
                       String table,
                       ValueDataMapper<T> valueDataMapper,
                       Collection<T> items,
                       ExecuteQuery executeQuery) {
        super(tablePrefix, table, OperationType.BATCH_UPDATE, valueDataMapper, items, executeQuery);
    }

    @Override
    protected String operationDescription(String table) {
        return "UPSERT INTO " + table + "\n";
    }
}
