package ru.yandex.webmaster3.storage.util.ydb.querybuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.yandex.ydb.table.values.Value;

import ru.yandex.webmaster3.storage.util.ydb.ExecuteQuery;
import ru.yandex.webmaster3.storage.util.ydb.exception.InvalidQueryParameters;
import ru.yandex.webmaster3.storage.util.ydb.query.Assignment;
import ru.yandex.webmaster3.storage.util.ydb.query.Clause;
import ru.yandex.webmaster3.storage.util.ydb.query.Statement;

/**
 * ishalaru
 * 18.06.2020
 **/
public class Update extends Statement {
    private With with;
    private Where where;
    private int index;
    private ExecuteQuery executeQuery;

    public Update(String tablePrefix, String table, ExecuteQuery executeQuery) {
        super(tablePrefix, table, OperationType.UPDATE);
        with = new With(this);
        where = new Where(this);
        this.executeQuery = executeQuery;
    }

    public With with(Assignment assignment) {
        return with.and(assignment);
    }

    @Override
    public String toQueryString() {
        StringBuilder sb = new StringBuilder(TABLE_PREFIX).append("'").append(tablePrefix).append("';\n");
        if (!with.list.isEmpty()) {
            with.appendDeclaration(sb);
        } else {
            throw new InvalidQueryParameters("Block with in update query can't be empty.");
        }
        if (!where.list.isEmpty()) {
            where.appendDeclaration(sb);
        } else {
            throw new InvalidQueryParameters("Block where in update query can't be empty.");
        }
        sb.append("UPDATE ").append(table).append("\nSET ");
        for (Assignment a : with.list) {
            a.appendTo(sb);
            sb.append(",\n");
        }
        sb.setLength(sb.length() - 2);
        sb.append("\nWHERE \n");
        where.append(sb).append(";");
        return sb.toString();
    }

    @Override
    public Map<String, Value> getParameters() {
        Map<String, Value> result = new HashMap<>();
        with.list.forEach(e -> e.putParameter(result));
        where.list.forEach(e -> e.putParameter(result));
        return result;
    }

    public void execute() {
        this.executeQuery.execute(this);
    }


    public static class With {
        List<Assignment> list;
        Update parent;

        public With(Update parent) {
            this.parent = parent;
            list = new ArrayList<>(6);
        }

        public Update.With and(Assignment assignment) {
            parent.index = assignment.initIndex(parent.index);
            list.add(assignment);
            return this;
        }

        public Where where(Clause dbFieldCondition) {
            return parent.where.and(dbFieldCondition);
        }

        public StringBuilder appendDeclaration(StringBuilder sb) {
            Set<Integer> declaredParameter = new HashSet<>();
            for (Assignment clause : list) {
                clause.appendDeclaration(sb, declaredParameter);
            }
            return sb;
        }

        StringBuilder append(StringBuilder sb) {
            for (int i = 0; i < list.size(); i++) {
                Assignment clause = list.get(i);
                if (i == list.size() - 1) {
                    clause.appendTo(sb);
                    sb.append("\n");
                } else {
                    clause.appendTo(sb);
                    sb.append(" and \n");
                }
            }
            return sb;
        }

        public void execute() {
            this.parent.execute();
        }

    }

    public static class Where {
        List<Clause> list;
        Update parent;

        public Where(Update parent) {
            this.parent = parent;
            list = new ArrayList<>(6);
        }

        public Update.Where and(Clause condition) {
            parent.index = condition.initIndex(parent.index);
            list.add(condition);
            return this;
        }

        public StringBuilder appendDeclaration(StringBuilder sb) {
            Set<Integer> declaredParameter = new HashSet<>();
            for (Clause clause : list) {
                clause.appendDeclaration(sb, declaredParameter);
            }
            return sb;
        }

        StringBuilder append(StringBuilder sb) {
            for (int i = 0; i < list.size(); i++) {
                Clause clause = list.get(i);
                if (i == list.size() - 1) {
                    clause.appendTo(sb);
                    sb.append("\n");
                } else {
                    clause.appendTo(sb);
                    sb.append(" and \n");
                }
            }
            return sb;
        }

        public Update getStatement() {
            return parent;
        }

        public void execute() {
            this.parent.execute();
        }
    }
}
