package ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.webmaster3.storage.util.ydb.query.Clause;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.Ordering;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.QueryBuilder;


/**
 * ishalaru
 * 16.06.2020
 **/
public interface AnyField<T> extends RowMapper<T> {
    Logger log = LoggerFactory.getLogger(AnyField.class);

    String getName();

    Object asDBValue(T value);

    @Override
    default Collection<String> getDependencyColumns() {
        return Collections.singleton(getName());
    }

    default Clause eq(T t) {
        return QueryBuilder.eq(getName(), asDBValue(t));
    }

    default Clause ne(T t) {
        return QueryBuilder.ne(getName(), asDBValue(t));
    }

    default Clause gt(T t) {
        return QueryBuilder.gt(getName(), asDBValue(t));
    }

    default Clause gte(T t) {
        return QueryBuilder.gte(getName(), asDBValue(t));
    }

    default Clause or(Clause a, Clause b) {
        return QueryBuilder.or(a, b);
    }

    default Clause lt(T t) {
        return QueryBuilder.lt(getName(), asDBValue(t));
    }

    default Clause lte(T t) {
        return QueryBuilder.lte(getName(), asDBValue(t));
    }

    default Clause in(T... values) {
        return in(Arrays.asList(values));
    }

    default Clause in(Collection<T> values) {
        if (CollectionUtils.isEmpty(values)) {
            return QueryBuilder.addFalse();
        }
        List<Object> list = values.stream().map(this::asDBValue).collect(Collectors.toList());
        return QueryBuilder.in(getName(), list);
    }

    default Clause like(T t) {
        return QueryBuilder.like(getName(), asDBValue(t));
    }

    default Ordering asc() {
        return QueryBuilder.asc(getName());
    }

    default Ordering desc() {
        return QueryBuilder.desc(getName());
    }

    default Ordering order(boolean desc) {
        return Ordering.create(getName(), desc);
    }

    default Object sum() {
        return QueryBuilder.sum(null, getName());
    }

    default Object sum(String alias) {
        return QueryBuilder.sum(alias, getName());
    }

    default Object avg(String alias) {
        return QueryBuilder.avg(alias, getName());
    }

    default Object avg() {
        return QueryBuilder.avg(null, getName());
    }

    default Clause isNull() {
        return QueryBuilder.isNull(getName());
    }

    default Clause isNotNull() {
        return QueryBuilder.notNull(getName());
    }
}
