package ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

import com.yandex.ydb.table.result.ResultSetReader;

import ru.yandex.webmaster3.core.util.functional.Functions;

/**
 * ishalaru
 * 16.06.2020
 **/
public abstract class DataMapper<T> implements RowMapper<T> {
    public static DataMapper<Integer> SINGLE_COLUMN_INT_MAPPER = DataMapper.createMapper(r -> (int)r.getColumn(0).getUint64());
    public static DataMapper<Long> SINGLE_COLUMN_LONG_MAPPER = DataMapper.createMapper(r -> r.getColumn(0).getUint64());

    private final Set<String> dependencyColumns;

    public DataMapper(RowMapper<?>... mappers) {
        this(new HashSet<>(), mappers);
    }

    public DataMapper(Collection<String> deps, RowMapper<?>... mappers) {
        Set<String> newDeps = new HashSet<>(deps);
        for (RowMapper<?> mapper : mappers) {
            newDeps.addAll(mapper.getDependencyColumns());
        }
        dependencyColumns = Collections.unmodifiableSet(newDeps);
    }

    public static <R> DataMapper<R> createMapper(Function<ResultSetReader, R> m, RowMapper<?>... cols) {
        return new DataMapper<R>(cols) {
            @Override
            public R get(ResultSetReader row) {
                return m.apply(row);
            }
        };
    }

    public static <T1, R> DataMapper<R> create(RowMapper<T1> m1, Functions.F1<T1, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row)), m1);
    }

    /* Generated static factories */

    public static <T1, T2, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, Functions.F2<T1, T2, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row)), m1, m2);
    }

    public static <T1, T2, T3, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, Functions.F3<T1, T2, T3, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row)), m1, m2, m3);
    }

    public static <T1, T2, T3, T4, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, Functions.F4<T1, T2, T3, T4, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row)), m1, m2, m3, m4);
    }

    public static <T1, T2, T3, T4, T5, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, Functions.F5<T1, T2, T3, T4, T5, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row)), m1, m2, m3, m4, m5);
    }

    public static <T1, T2, T3, T4, T5, T6, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, Functions.F6<T1, T2, T3, T4, T5, T6, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row)), m1, m2, m3, m4, m5, m6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, Functions.F7<T1, T2, T3, T4, T5, T6, T7, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row)), m1, m2, m3, m4, m5, m6, m7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, Functions.F8<T1, T2, T3, T4, T5, T6, T7, T8, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row)), m1, m2, m3, m4, m5, m6, m7, m8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, Functions.F9<T1, T2, T3, T4, T5, T6, T7, T8, T9, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, Functions.F10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, Functions.F11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, Functions.F12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, Functions.F13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, Functions.F14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, Functions.F15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, Functions.F16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, Functions.F17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, Functions.F18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, Functions.F19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, Functions.F20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, Functions.F21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, Functions.F22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, Functions.F23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, RowMapper<T24> m24, Functions.F24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row), m24.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, RowMapper<T24> m24, RowMapper<T25> m25, Functions.F25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row), m24.get(row), m25.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, RowMapper<T24> m24, RowMapper<T25> m25, RowMapper<T26> m26, Functions.F26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row), m24.get(row), m25.get(row), m26.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, RowMapper<T24> m24, RowMapper<T25> m25, RowMapper<T26> m26, RowMapper<T27> m27, Functions.F27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row), m24.get(row), m25.get(row), m26.get(row), m27.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, RowMapper<T24> m24, RowMapper<T25> m25, RowMapper<T26> m26, RowMapper<T27> m27, RowMapper<T28> m28, Functions.F28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row), m24.get(row), m25.get(row), m26.get(row), m27.get(row), m28.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, RowMapper<T24> m24, RowMapper<T25> m25, RowMapper<T26> m26, RowMapper<T27> m27, RowMapper<T28> m28, RowMapper<T29> m29, Functions.F29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row), m24.get(row), m25.get(row), m26.get(row), m27.get(row), m28.get(row), m29.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30, R> DataMapper<R> create(RowMapper<T1> m1, RowMapper<T2> m2, RowMapper<T3> m3, RowMapper<T4> m4, RowMapper<T5> m5, RowMapper<T6> m6, RowMapper<T7> m7, RowMapper<T8> m8, RowMapper<T9> m9, RowMapper<T10> m10, RowMapper<T11> m11, RowMapper<T12> m12, RowMapper<T13> m13, RowMapper<T14> m14, RowMapper<T15> m15, RowMapper<T16> m16, RowMapper<T17> m17, RowMapper<T18> m18, RowMapper<T19> m19, RowMapper<T20> m20, RowMapper<T21> m21, RowMapper<T22> m22, RowMapper<T23> m23, RowMapper<T24> m24, RowMapper<T25> m25, RowMapper<T26> m26, RowMapper<T27> m27, RowMapper<T28> m28, RowMapper<T29> m29, RowMapper<T30> m30, Functions.F30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30, R> mapper) {
        return createMapper(row -> mapper.apply(m1.get(row), m2.get(row), m3.get(row), m4.get(row), m5.get(row), m6.get(row), m7.get(row), m8.get(row), m9.get(row), m10.get(row), m11.get(row), m12.get(row), m13.get(row), m14.get(row), m15.get(row), m16.get(row), m17.get(row), m18.get(row), m19.get(row), m20.get(row), m21.get(row), m22.get(row), m23.get(row), m24.get(row), m25.get(row), m26.get(row), m27.get(row), m28.get(row), m29.get(row), m30.get(row)), m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30);
    }

    @Override
    public Collection<String> getDependencyColumns() {
        return dependencyColumns;
    }
}
