package ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe;

import java.util.function.Function;

import com.yandex.ydb.table.result.ResultSetReader;
import com.yandex.ydb.table.values.OptionalType;
import com.yandex.ydb.table.values.OptionalValue;
import com.yandex.ydb.table.values.Type;
import com.yandex.ydb.table.values.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.webmaster3.core.util.functional.Bijection;
import ru.yandex.webmaster3.storage.util.ydb.query.Assignment;
import ru.yandex.webmaster3.storage.util.ydb.query.DbFieldInsertAssignment;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.QueryBuilder;


/**
 * ishalaru
 * 05.06.2020
 **/

public interface Field<T> extends AnyField<T> {
    Logger log = LoggerFactory.getLogger(Field.class);

    Value get(T item);

    Type getType();

    Field<T> withDefault(T value);

    default Field<T> makeOptional() {
        Field<T> delegate = this;
        return new Field<T>() {

            @Override
            public T get(ResultSetReader row) {
                return delegate.get(row);
            }

            @Override
            public String getName() {
                return delegate.getName();
            }

            @Override
            public Object asDBValue(T value) {
                return delegate.asDBValue(value);
            }

            @Override
            public Value get(T item) {
                if (item == null) {
                    return getType().emptyValue();
                }
                return OptionalValue.of(delegate.get(item));
            }

            @Override
            public OptionalType getType() {
                return delegate.getType().makeOptional();
            }

            @Override
            public Field<T> withDefault(T value) {
                return delegate.withDefault(value);
            }

        };
    }

    default <X> Field<X> map(Bijection<T, X> bijection) {
        return new Fields.DelegateAnyField<>(this, bijection);
    }

    default Assignment set(T t) {
        return new Assignment(getName(), getType(), get(t));
    }

    default Assignment setNull() {
        return new Assignment(getName(), getType());
    }

    default DbFieldInsertAssignment value(T t) {
        return new DbFieldInsertAssignment(getName(), getType(), get(t));
    }

    default DbFieldInsertAssignment nullValue() {
        return new DbFieldInsertAssignment(getName(), getType());
    }

    default AnyField<Long> count(String alias) {
        return QueryBuilder.count(alias, this);
    }

    default AnyField<Long> count() {
        return QueryBuilder.count(null, this);
    }

    default AnyField<String> toLower(String alias) {
        return QueryBuilder.MCall(alias, this, "String::ToLower", e -> e.getColumn(alias).getUtf8());
    }

    default AnyField<String> toLower() {
        return toLower(null);
    }

    default AnyField<String> toUpper(String alias) {
        return QueryBuilder.MCall(alias, this, "String::ToUpper", e -> e.getColumn(alias).getUtf8());
    }

    default AnyField<String> toUpper() {
        return toUpper(null);
    }



}
