package ru.yandex.webmaster3.storage.util.yt;

import org.apache.commons.collections4.collection.CompositeCollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public abstract class AbstractYtJobBuilder<Self extends AbstractYtJobBuilder<?>> {
    protected List<YtPath> inputTables = new ArrayList<>();
    protected List<YtPath> outputTables = new ArrayList<>();
    protected String ytCluster;
    protected Map<String, Object> secureVault = new HashMap<>();
    protected Map<String, Object> spec = new HashMap<>();

    protected abstract Self getSelf();

    public Self setYtCluster(String ytCluster) {
        this.ytCluster = ytCluster;
        return getSelf();
    }

    public Self addInputTable(YtPath table) {
        inputTables.add(table);
        return getSelf();
    }

    public Self setInputTables(Collection<YtPath> tables) {
        this.inputTables = new ArrayList<>(tables);
        return getSelf();
    }

    public Self addOutputTable(YtPath table) {
        outputTables.add(table);
        return getSelf();
    }

    public Self setOutputTables(Collection<YtPath> tables) {
        this.outputTables = new ArrayList<>(tables);
        return getSelf();
    }

    public Self addSecureVault(String key, Object value) {
        secureVault.put(key, value);
        return getSelf();
    }

    public Self addSpec(String key, Object value) {
        spec.put(key, value);
        return getSelf();
    }

    protected void preBuild() {
        if (inputTables == null || inputTables.isEmpty()) {
            throw new IllegalStateException("Input tables not set");
        }
        if (outputTables == null || outputTables.isEmpty()) {
            throw new IllegalStateException("Output tables not set");
        }
        for (YtPath table : new CompositeCollection<>(inputTables, outputTables)) {
            if (ytCluster == null) {
                ytCluster = table.getCluster();
            } else {
                if (!ytCluster.equals(table.getCluster())) {
                    throw new IllegalStateException("Different YT clusters found in input/output tables: " + ytCluster + ", " + table.getCluster());
                }
            }
        }
    }

}
