package ru.yandex.webmaster3.storage.util.yt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author aherman
 */
public class Format {
    private final Object formatYson;
    private final FormatType type;

    Format(Object formatYson, FormatType type) {
        this.formatYson = formatYson;
        this.type = type;
    }

    Object getFormatYson() {
        return formatYson;
    }

    public FormatType getFormatType() {
        return type;
    }

    public static Format createSchemafulDsv(String... columns) {
        return createSchemafulDsv(Arrays.asList(columns));
    }

    public static Format createSchemafulDsv(List<String> columns) {
        HashMap<String, Object> schemafulYson = new HashMap<>();
        schemafulYson.put("$value", "schemaful_dsv");

        Map<String, List<String>> attrs = new HashMap<>();
        attrs.put("columns", columns);
        schemafulYson.put("$attributes", attrs);

        return new Format(schemafulYson, FormatType.SCHEMAFUL_DSV);
    }

    public static Format createBinaryYson() {
        HashMap<String, Object> binaryYson = new HashMap<>();
        binaryYson.put("$value", "yson");

        Map<String, String> attrs = new HashMap<>();
        attrs.put("format", "binary");
        binaryYson.put("$attributes", attrs);

        return new Format(binaryYson, FormatType.BINARY_YSON);
    }

    public static enum FormatType {
        BINARY_YSON,
        SCHEMAFUL_DSV,
    }
}
