package ru.yandex.webmaster3.storage.util.yt;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * @author aherman
 */
abstract class OutputFormat {
    public abstract Object getFormatYson();

    public static OutputFormat createSchemafulDsv(List<String> columns, YtMissingValueMode missingValueMode) {
        return new SchemafulDsvFormat(columns, missingValueMode);
    }

    public static OutputFormat createBinaryYson() {
        return new YsonFormat(YsonFormatOption.binary);
    }

    private static class SchemafulDsvFormat extends OutputFormat {
        private final List<String> columns;
        private final YtMissingValueMode missingValueMode;

        private SchemafulDsvFormat(List<String> columns, YtMissingValueMode missingValueMode) {
            this.columns = columns;
            this.missingValueMode = missingValueMode;
        }

        @Override
        public Object getFormatYson() {
            return new SchemafulDsvYson(columns, missingValueMode);
        }
    }

    private static class SchemafulDsvYson {
        private final String value = "schemaful_dsv";
        private final DSVFormatAttributes attributes;

        public SchemafulDsvYson(List<String> columns, YtMissingValueMode missingValueMode) {
            this.attributes = new DSVFormatAttributes(columns, missingValueMode);
        }

        @JsonProperty("$value")
        public String getValue() {
            return value;
        }

        @JsonProperty("$attributes")
        public DSVFormatAttributes getAttributes() {
            return attributes;
        }
    }

    private static class DSVFormatAttributes {
        private final List<String> columns;
        private final YtMissingValueMode missingValueMode;

        private DSVFormatAttributes(List<String> columns, YtMissingValueMode missingValueMode) {
            this.columns = columns;
            this.missingValueMode = missingValueMode;
        }

        public List<String> getColumns() {
            return columns;
        }

        @JsonInclude(JsonInclude.Include.NON_NULL)
        @JsonProperty("missing_value_mode")
        public String getMissingValueMode() {
            return missingValueMode.getYtMode();
        }
    }

    private static class YsonFormat extends OutputFormat {
        private final YsonFormatYson yson;

        public YsonFormat(YsonFormatOption formatOption) {
            this.yson = new YsonFormatYson(formatOption);
        }

        @Override
        public Object getFormatYson() {
            return yson;
        }
    }

    private static class YsonFormatYson {
        private final YsonFormatAttributes attributes;

        public YsonFormatYson(YsonFormatOption formatOption) {
            this.attributes = new YsonFormatAttributes(formatOption);
        }

        @JsonProperty("$value")
        public String getValue() {
            return "yson";
        }

        @JsonProperty("$attributes")
        public YsonFormatAttributes getAttributes() {
            return attributes;
        }
    }

    private static class YsonFormatAttributes {
        private final YsonFormatOption format;

        public YsonFormatAttributes(YsonFormatOption format) {
            this.format = format;
        }

        public YsonFormatOption getFormat() {
            return format;
        }
    }

    private enum YsonFormatOption {
        binary,
    }
}
