package ru.yandex.webmaster3.storage.util.yt;

import com.google.common.collect.Range;

/**
 * @author aherman
 */
public interface TableReaderBuilder {
    TableReaderBuilder withLock(YtLockMode mode);

    TableReaderBuilder withCompression(boolean compression);

    TableReaderBuilder withRowCache(long subrangeSize);

    TableReaderBuilder withRetry(int retryCount);

    TableReaderBuilder rowRange(Range<Long> range);

    TableReaderBuilder withCaching(ThreadGroup threadGroup, String threadName);

    <T> InterruptableIterator<T> readInLenvalFormat(YtRowMapper<T> ytRowMapper) throws YtException, InterruptedException;

    <T> InterruptableIterator<T> readInSchemafulDsvFormat(YtRowMapper<T> ytRowMapper) throws YtException, InterruptedException;
}
