package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtAbortTxCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtTransaction transaction;

    public YtAbortTxCommand(YtTransaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/abort_tx")
                .queryParam(PARAMETER_TRANSACTION_ID, transaction.getId());
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "ABORT_TX " + transaction;
    }
}
