package ru.yandex.webmaster3.storage.util.yt;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;

/**
 * @author leonidrom
 */
public class YtAlterTableReplicaCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtReplicaId replicaId;

    @Nullable
    private final Boolean isEnabled;

    @Nullable
    private final ReplicationMode replicationMode;

    public YtAlterTableReplicaCommand(YtReplicaId replicaId, @Nullable Boolean isEnabled, @Nullable ReplicationMode replicationMode) {
        this.replicaId = replicaId;
        this.isEnabled = isEnabled;
        this.replicationMode = replicationMode;
    }

    public YtAlterTableReplicaCommand(YtReplicaId replicaId, @NotNull Boolean isEnabled) {
        this(replicaId, isEnabled, null);
    }

    public YtAlterTableReplicaCommand(YtReplicaId replicaId, @NotNull ReplicationMode replicationMode) {
        this(replicaId, null, replicationMode);
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        UriComponentsBuilder uri = UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/alter_table_replica")
                .queryParam("replica_id", replicaId.getId());

        if (isEnabled != null) {
            uri.queryParam(isEnabled? "enabled" : "disabled");
        }

        if (replicationMode != null) {
            uri.queryParam("mode", replicationMode.ytMode);
        }

        return uri;
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    public enum ReplicationMode {
        SYNC("sync"),
        ASYNC("async"),
        ;

        final String ytMode;

        ReplicationMode(String ytMode) {
            this.ytMode = ytMode;
        }
    }
}
