package ru.yandex.webmaster3.storage.util.yt;

/**
 * @author aherman
 */
public class YtCommandException extends YtException {
    private final YtStatus status;
    private final String errorText;

    public YtCommandException(String command, YtStatus status, String errorText) {
        super("Error in command: " + command + " " + status + " " + String.valueOf(errorText));
        this.status = status;
        this.errorText = errorText;
    }

    public YtCommandException(String command, YtStatus status, String errorText, Throwable cause) {
        super("Error in command: " + command + " " + status + " " + String.valueOf(errorText), cause);
        this.status = status;
        this.errorText = errorText;
    }

    public YtStatus getStatus() {
        return status;
    }

    public String getErrorText() {
        return errorText;
    }
}
