package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtCommitTxCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtTransaction transactionId;

    public YtCommitTxCommand(YtTransaction transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/commit_tx")
                .queryParam(PARAMETER_TRANSACTION_ID, transactionId.getId());
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "COMMIT_TX " + transactionId;
    }
}
