package ru. yandex.webmaster3.storage.util.yt;

import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;

/**
 * @author leonidrom
 */
public class YtConvertTableToDynamicCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtPath path;

    public YtConvertTableToDynamicCommand(YtPath path) {
        this.path = path;
    }

    @Override
    protected UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri)
                .path(API_V3 + "/alter_table")
                .queryParam("dynamic", true)
                .queryParam(PARAMETER_PATH, path.toYtPath());
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }
}
