package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtCopyCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtPath sourcePath;
    private final YtPath destinationPath;
    private boolean recursive;

    public YtCopyCommand(YtPath sourcePath, YtPath destinationPath) {
        this.sourcePath = sourcePath;
        this.destinationPath = destinationPath;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        UriComponentsBuilder uri = UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/copy")
                .queryParam(PARAMETER_SOURCE_PATH, sourcePath.toYtPath())
                .queryParam(PARAMETER_DESTINATION_PATH, destinationPath.toYtPath());
        if (recursive) {
            uri = uri.queryParam(PARAMETER_RECURSIVE, VALUE_TRUE);
        }
        return uri;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "COPY " + sourcePath + " TO " + destinationPath;
    }
}
