package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtCreateCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtPath path;
    private final YtNode.NodeType type;
    private boolean recursive;
    private YtNodeAttributes attributes;
    private boolean ignoreExisting;

    YtCreateCommand(YtPath path, YtNode.NodeType type, YtNodeAttributes attributes, boolean ignoreExisting) {
        this.path = path;
        this.type = type;
        this.attributes = attributes;
        this.ignoreExisting = ignoreExisting;
    }

    void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        UriComponentsBuilder uri = UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/create")
                .queryParam(PARAMETER_PATH, this.path.toYtPath())
                .queryParam(PARAMETER_TYPE, type.ytType)
                .queryParam(PARAMETER_RECURSIVE, recursive)
                .queryParam(PARAMETER_IGNORE_EXISTING, ignoreExisting);
        return uri;
    }

    @Override
    protected Object getYtParameters() {
        Map<String, Object> result = new HashMap<>();
        if (attributes != null) {
            result.put("attributes", attributes.getAttributes());
        }
        return result;
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "CREATE " + path;
    }
}
