package ru.yandex.webmaster3.storage.util.yt;

import ru.yandex.webmaster3.storage.util.clickhouse2.BAInputStream;

/**
 * @author aherman
 */
public class YtEscapeUtils {
    public static BAInputStream unescape(BAInputStream is) {
        return new UnescapingInputStream(is);
    }

    private static class UnescapingInputStream extends BAInputStream {
        private final BAInputStream is;

        private UnescapingInputStream(BAInputStream is) {
            this.is = is;
        }

        @Override
        public int read() {
            int value = is.read();
            if (value == -1) {
                return -1;
            }
            if (value != '\\') {
                return value;
            }
            value = is.read();
            if (value == -1) {
                throw new RuntimeException("Broken escape sequence");
            }
            switch (value) {
                case '0': return '\0';
                case 'n': return '\n';
                case 't': return '\t';
                case 'r': return '\r';
                case '\\': return '\\';
            }
            throw new RuntimeException("Broken escape sequence");
        }

        @Override
        public void resetPosition() {
            is.resetPosition();
        }
    }

}
