package ru.yandex.webmaster3.storage.util.yt;

import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.WebmasterStorageException;

/**
 * @author aherman
 */
public class YtException extends WebmasterStorageException {
    public YtException(String message) {
        super(message);
    }

    public YtException(String message, Throwable cause) {
        super(message, cause);
    }

    public YtException(Throwable cause) {
        super(cause);
    }

    @Override
    protected WebmasterErrorResponse errorResponse(Class cls) {
        return new WebmasterErrorResponse.YTServiceErrorResponse(cls, this);
    }
}
