package ru.yandex.webmaster3.storage.util.yt;

import java.io.IOException;
import java.net.URI;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtExistsCommand extends YtCommandImpl.GetCommand<Boolean> {
    private final YtPath path;

    YtExistsCommand(YtPath path) {
        this.path = path;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/exists");
    }

    @Override
    protected Object getYtParameters() {
        return new Parameters(path.toYtPath());
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    protected YtResult<Boolean> onSuccess(YtStatus status, HttpResponse httpResponse) throws YtCommandException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return YtResult.createError(status, "Response is empty", null);
        }
        try {
            String resultStr = EntityUtils.toString(entity);
            Boolean result = YtService.OM.readValue(resultStr, Boolean.class);
            return YtResult.createResult(status, result);
        } catch (IOException e) {
            return YtResult.createError(status, "Unable to read response", e);
        }
    }

    @Override
    public String toString() {
        return "EXISTS " + path;
    }

    private static class Parameters {
        private final String path;

        public Parameters(String path) {
            this.path = path;
        }

        public String getPath() {
            return path;
        }
    }
}
