package ru.yandex.webmaster3.storage.util.yt;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

/**
 * @author avhaliullin
 */
public class YtGetOperationCommand extends YtCommandImpl.GetCommand<JsonNode> {
    private final YtOperationId operationId;

    public YtGetOperationCommand(YtOperationId operationId) {
        this.operationId = operationId;
    }

    @Override
    protected Object getYtParameters() {
        return new Parameters(operationId.getId());
    }

    @Override
    protected UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/get_operation");
    }

    @Override
    protected YtResult<JsonNode> onSuccess(YtStatus status, HttpResponse httpResponse) throws YtCommandException {
        try {
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                return YtResult.createError(status, "Unable to read response", null);
            }
            try(InputStream content = entity.getContent()) {
                JsonNode jsonNode = YtService.OM.readTree(content);
                return YtResult.createResult(status, jsonNode);
            }
        } catch (IOException e) {
            return YtResult.createError(status, "Invalid json from YT", e);
        }
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    private static class Parameters {
        @JsonProperty("operation_id")
        public final String operationId;

        public Parameters(String operationId) {
            this.operationId = operationId;
        }
    }
}
