package ru.yandex.webmaster3.storage.util.yt;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author leonidrom
 */
public class YtGetRowsCommand<T> extends YtAbstractReadTableCommand<List<T>> {
    private final YtTableReadDriver<T> tableReadDriver;

    public YtGetRowsCommand(YtPath path, List<Object> keyValues,
                                 YtTableReadDriver<T> tableReadDriver) {
        super(false, path, keyValues, tableReadDriver.getFormat());
        this.tableReadDriver = tableReadDriver;
    }

    @Override
    protected YtResult<List<T>> onSuccess(YtStatus status, HttpResponse httpResponse) throws YtCommandException {
        if (status != YtStatus.YT_200_OK) {
            return YtResult.createError(status, "Unable to read table", null);
        }

        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return YtResult.createResult(status, Collections.emptyList());
        } else {
            List<T> res = new ArrayList<>();
            try {
                var parser = tableReadDriver.createParser(entity.getContent());
                while (parser.hasNext()) {
                    res.add(parser.next());
                }

                return YtResult.createResult(status, res);
            } catch (Exception e) {
                return YtResult.createError(status, "Unable to read response", e);
            }
        }
    }
}
