package ru.yandex.webmaster3.storage.util.yt;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public abstract class YtJobIOSpec {
    private final long tableWriterMaxRowWeight;

    public YtJobIOSpec(long tableWriterMaxRowWeight) {
        this.tableWriterMaxRowWeight = tableWriterMaxRowWeight;
    }

    @JsonProperty("table_writer")
    public Map<String, Object> getTableWriter() {
        Map<String, Object> result = new HashMap<>();
        result.put("max_row_weight", tableWriterMaxRowWeight);
        return result;
    }
}
