package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtLinkCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtPath targetPath;
    private final YtPath linkPath;
    private final boolean force;

    public YtLinkCommand(YtPath targetPath,
                         YtPath linkPath,
                         boolean force) {
        this.targetPath = targetPath;
        this.linkPath = linkPath;
        this.force = force;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/link")
                .queryParam(PARAMETER_TARGET_PATH, targetPath.toYtPath())
                .queryParam(PARAMETER_LINK_PATH, linkPath.toYtPath())
                .queryParam(PARAMETER_FORCE, force);
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "LINK " + targetPath + " TO " + linkPath;
    }
}
