package ru.yandex.webmaster3.storage.util.yt;

import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;

/**
 * @author aherman
 */
class YtLockCommand extends YtCommandImpl.PostCommand<Void> {
    private final String path;
    private final YtLockMode mode;

    public YtLockCommand(String path, YtLockMode mode) {
        this.path = path;
        this.mode = mode;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/lock")
                .queryParam(PARAMETER_PATH, path)
                .queryParam("mode", mode.getYtMode());
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "LOCK " + mode + " " + path;
    }
}
