package ru.yandex.webmaster3.storage.util.yt;


import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class YtMapCommand extends AbstractYtJob {
    private final YtJobSpec mapperSpec;

    YtMapCommand(String ytCluster, List<YtPath> inputTables, List<YtPath> outputTables, Map<String, Object> secureVault, Map<String, Object> spec,
                 YtJobSpec mapperSpec) {
        super("map", ytCluster, inputTables, outputTables, secureVault, spec);
        this.mapperSpec = mapperSpec;
    }

    @Override
    protected void fillSpec(Map<String, Object> spec) {
        super.fillSpec(spec);
        spec.put("mapper", mapperSpec);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder extends AbstractYtJobBuilder<Builder> {
        private YtJobSpec mapperSpec;

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder setMapper(YtJobSpec mapperSpec) {
            this.mapperSpec = mapperSpec;
            return this;
        }

        public YtMapCommand build() {
            preBuild();
            return new YtMapCommand(ytCluster, inputTables, outputTables, secureVault, spec, mapperSpec);
        }
    }
}
