package ru.yandex.webmaster3.storage.util.yt;

/**
 * Created by leonidrom on 10/03/2017.
 */

/**
 * Поведение при чтении в случае отсутствия значения в колонке Yt таблицы.
 * Значения взяты из https://wiki.yandex-team.ru/yt/userdoc/formats/#schemafuldsv
 */
public enum YtMissingValueMode {
    // Пропустить строку; было дефолтным поведением до мая 2016
    SKIP_ROW("skip_row"),

    // дефолтное поведение с мая 2016; упасть, если не нашлось указанной колонки в одной из строк
    FAIL("fail"),

    // печатает у отсутствующих значений missing_value_sentinel, который по-дефолту равен пустой строке
    PRINT_SENTINEL("print_sentinel"),

    // Не передавать параметр
    DEFAULT(null),
    ;

    private final String ytMode;

    YtMissingValueMode(String ytMode) {
        this.ytMode = ytMode;
    }

    public String getYtMode() {
        return ytMode;
    }
}
