package ru.yandex.webmaster3.storage.util.yt;

import org.springframework.web.util.UriComponentsBuilder;

import java.net.URI;

/**
 * @author leonidrom
 */
public class YtMountCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtPath path;

    public YtMountCommand(YtPath path) {
        this.path = path;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/mount_table")
                .queryParam(PARAMETER_PATH, path.toYtPath());
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "MOUNT " + path;
    }
}
