package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtMoveCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtPath sourcePath;
    private final YtPath destinationPath;
    private final boolean recursive;
    private final boolean force;

    public YtMoveCommand(YtPath sourcePath, YtPath destinationPath, boolean recursive, boolean force) {
        this.sourcePath = sourcePath;
        this.destinationPath = destinationPath;
        this.recursive = recursive;
        this.force = force;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        UriComponentsBuilder uri = UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/move")
                .queryParam(PARAMETER_SOURCE_PATH, sourcePath.toYtPath())
                .queryParam(PARAMETER_DESTINATION_PATH, destinationPath.toYtPath());
        if (recursive) {
            uri = uri.queryParam(PARAMETER_RECURSIVE, VALUE_TRUE);
        }
        if (force) {
            uri = uri.queryParam(PARAMETER_FORCE, VALUE_TRUE);
        }
        return uri;
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "MOVE " + sourcePath + " TO " + destinationPath;
    }
}
