package ru.yandex.webmaster3.storage.util.yt;

import com.fasterxml.jackson.databind.JsonNode;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author aherman
 */
public class YtNode {
    private final YtPath path;
    private final String id;
    private final String owner;
    private final DateTime createdTime;
    private final DateTime updateTime;
    private final NodeType nodeType;
    private final JsonNode nodeMeta;

    public YtNode(YtPath path, NodeType nodeType, String id, String owner, DateTime createdTime, DateTime updateTime,
                  JsonNode nodeMeta) {
        this.path = path;
        this.nodeType = nodeType;
        this.id = id;
        this.owner = owner;
        this.createdTime = createdTime;
        this.updateTime = updateTime;
        this.nodeMeta = nodeMeta;
    }

    public NodeType getNodeType() {
        return nodeType;
    }

    public YtPath getPath() {
        return path;
    }

    public String getId() {
        return id;
    }

    public String getOwner() {
        return owner;
    }

    public DateTime getCreatedTime() {
        return createdTime;
    }

    public DateTime getUpdateTime() {
        return updateTime;
    }

    public static enum NodeType {
        UNKNOWN("UNKNOWN"),

        TABLE("table"),
        REPLICATED_TABLE("replicated_table"),
        FILE("file"),
        LINK("link"),
        MAP_NODE("map_node"),
        ;

        final String ytType;

        NodeType(String ytType) {
            this.ytType = ytType;
        }

        static NodeType getType(String ytType) {
            for (NodeType type : NodeType.values()) {
                if (type.ytType.equals(ytType)) {
                    return type;
                }
            }
            return UNKNOWN;
        }

        public static final EnumResolver<NodeType> R = EnumResolver.er(NodeType.class);
    }

    public JsonNode getNodeMeta() {
        return nodeMeta;
    }
}
