package ru.yandex.webmaster3.storage.util.yt;

import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class YtNodeAttributes {
    private final Map<String, Object> attributes = new HashMap<>();

    public static YtNodeAttributes create(String name, Object value) {
        final YtNodeAttributes ytNodeAttributes = new YtNodeAttributes();
        ytNodeAttributes.addAttribute(name, value);
        return ytNodeAttributes;
    }

    public static YtNodeAttributes updateExpiredDate(Long timestamp) {
        YtNodeAttributes ytNodeAttributes = new YtNodeAttributes();
        ytNodeAttributes.addAttribute("expiration_time", timestamp);
        return ytNodeAttributes;
    }

    public YtNodeAttributes setCompressionCodec(String codec) {
        if (codec == null) {
            attributes.remove("compression_codec");
        } else {
            attributes.put("compression_codec", codec);
        }
        return this;
    }

    public YtNodeAttributes setSchema(YtSchema ytSchema) {
        attributes.put("schema", ytSchema.getJsonSchema());
        return this;
    }

    public void addAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }


}
