package ru.yandex.webmaster3.storage.util.yt;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author aherman
 */
public class YtOperation extends YtOperationId {
    private final OperationState state;
    private final DateTime startTime;
    private final int totalJobs;
    private final int pendingJobs;
    private final int runningJobs;
    private final int completedJobs;

    public YtOperation(YtOperationId operationId,
            OperationState state, DateTime startTime, int totalJobs, int pendingJobs, int runningJobs,
            int completedJobs)
    {
        super(operationId.getCluster(), operationId.getId());
        this.state = state;
        this.startTime = startTime;
        this.totalJobs = totalJobs;
        this.pendingJobs = pendingJobs;
        this.runningJobs = runningJobs;
        this.completedJobs = completedJobs;
    }

    public OperationState getState() {
        return state;
    }

    public DateTime getStartTime() {
        return startTime;
    }

    public int getTotalJobs() {
        return totalJobs;
    }

    public int getPendingJobs() {
        return pendingJobs;
    }

    public int getRunningJobs() {
        return runningJobs;
    }

    public int getCompletedJobs() {
        return completedJobs;
    }

    public static enum OperationState {
        UNKNOWN(true),

        INITIALIZING(false),
        PREPARING(false),
        MATERIALIZING(false),
        REVIVING(false),
        PENDING(false),
        RUNNING(false),
        COMPLETING(false),
        COMPLETED(true),
        ABORTING(false),
        ABORTED(true),
        FAILING(false),
        FAILED(true),
        ;
        private final boolean terminal;

        OperationState(boolean terminal) {
            this.terminal = terminal;
        }

        public boolean isTerminal() {
            return terminal;
        }

        public static EnumResolver<OperationState> R = EnumResolver.er(OperationState.class);
    }
}
