package ru.yandex.webmaster3.storage.util.yt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.HashMap;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class YtOperationFilePathSpec {
    private final String path;
    private final boolean executable;
    private final String name;

    public YtOperationFilePathSpec(String path, boolean executable, String name) {
        this.path = path;
        this.executable = executable;
        this.name = name;
    }

    @JsonIgnore
    public String getName() {
        return name;
    }

    @JsonIgnore
    public boolean isExecutable() {
        return executable;
    }

    @JsonProperty("$value")
    public String getPath() {
        return path;
    }

    @JsonProperty("$attributes")
    public Map<String, Object> getAttributes() {
        Map<String, Object> attrs = new HashMap<>();
        attrs.put("file_name", name);
        attrs.put("executable", executable);
        return attrs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String path;
        private String name;
        private boolean executable;

        public Builder setPath(YtPath path) {
            this.path = path.toYtPath();
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setExecutable(boolean executable) {
            this.executable = executable;
            return this;
        }

        public YtOperationFilePathSpec build() {
            return new YtOperationFilePathSpec(path, executable, name);
        }
    }
}
