package ru.yandex.webmaster3.storage.util.yt;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;

/**
 * @author aherman
 */
public class YtOperationId {
    public static final String OPERATION_PREFIX = "OPERATION:";

    private final String cluster;
    private final String id;

    @JsonCreator
    public YtOperationId(String cluster, String id) {
        this.cluster = cluster;
        this.id = id;
    }

    public String getCluster() {
        return cluster;
    }

    public String getId() {
        return id;
    }

    public static YtOperationId fromString(String s) {
        if (s.startsWith(OPERATION_PREFIX)) {
            s = s.substring(OPERATION_PREFIX.length());
        }
        String[] parts = s.split(":");
        Preconditions.checkArgument(parts.length == 2);
        return new YtOperationId(parts[0], parts[1]);
    }

    @Override
    public String toString() {
        return OPERATION_PREFIX + cluster + ":" + id;
    }
}
