package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtPingTxCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtTransaction transactionId;

    public YtPingTxCommand(YtTransaction transactionId) {
        this.transactionId = transactionId;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/ping_tx")
                .queryParam(PARAMETER_TRANSACTION_ID, transactionId.getId());
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "PING " + transactionId;
    }
}
