package ru.yandex.webmaster3.storage.util.yt;


import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;

/**
 * @author aherman
 */
public class YtReduceCommand extends AbstractYtJob {
    private final YtJobSpec reducerSpec;
    private final List<String> sortBy;
    private final List<String> reduceBy;
    private final YtReduceIOSpec reduceJobIo;

    YtReduceCommand(String ytCluster, List<YtPath> inputTables, List<YtPath> outputTables,
                       Map<String, Object> secureVault, YtJobSpec reducerSpec, List<String> sortBy, List<String> reduceBy, YtReduceIOSpec reduceJobIo) {
        super("reduce", ytCluster, inputTables, outputTables, secureVault, Collections.emptyMap());
        this.reducerSpec = reducerSpec;
        this.sortBy = sortBy;
        this.reduceBy = reduceBy;
        this.reduceJobIo = reduceJobIo;
    }

    @Override
    protected void fillSpec(Map<String, Object> spec) {
        super.fillSpec(spec);
        spec.put("reducer", reducerSpec);
        spec.put("reduce_by", reduceBy);

        if (!CollectionUtils.isEmpty(sortBy)) {
            spec.put("sort_by", sortBy);
        }
        if (reduceJobIo != null) {
            spec.put("reduce_job_io", reduceJobIo);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder extends AbstractYtJobBuilder<Builder> {
        private YtJobSpec reducerSpec;
        private List<String> reduceBy;
        private List<String> sortBy;
        private YtReduceIOSpec reduceJobIo;

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder setReducer(YtJobSpec reducerSpec) {
            this.reducerSpec = reducerSpec;
            return this;
        }

        public Builder reduceBy(String... columns) {
            reduceBy = Arrays.asList(columns);
            return this;
        }

        public Builder sortBy(String... columns) {
            sortBy = Arrays.asList(columns);
            return this;
        }

        public Builder setReduceJobIo(YtReduceIOSpec ioSpec) {
            this.reduceJobIo = ioSpec;
            return this;
        }

        public YtReduceCommand build() {
            preBuild();
            if (CollectionUtils.isEmpty(reduceBy)) {
                throw new IllegalStateException("reduce_by columns must be specified");
            }
            return new YtReduceCommand(ytCluster, inputTables, outputTables, secureVault, reducerSpec, sortBy, reduceBy, reduceJobIo);
        }
    }
}
