package ru.yandex.webmaster3.storage.util.yt;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author aherman
 */
class YtRemoveCommand extends YtCommandImpl.PostCommand<Void> {
    private final YtPath path;
    private final boolean recursive;
    private final boolean force;

    YtRemoveCommand(YtPath path, boolean recursive, boolean force) {
        this.path = path;
        this.recursive = recursive;
        this.force = force;
    }

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        return UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/remove")
                .queryParam(PARAMETER_PATH, path.toYtPath())
                .queryParam(PARAMETER_RECURSIVE, recursive)
                .queryParam(PARAMETER_FORCE, force);
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    public String toString() {
        return "REMOVE " + path;
    }
}
