package ru.yandex.webmaster3.storage.util.yt;

import org.apache.commons.lang3.StringUtils;

/**
 * @author aherman
 */
public class YtResult<T> {
    private final YtStatus status;
    private final T result;
    private final String error;
    private final Exception e;

    YtResult(YtStatus status, T result, String error, Exception e) {
        this.status = status;
        this.result = result;
        this.error = error;
        this.e = e;
    }

    public YtStatus getStatus() {
        return status;
    }

    public T getResult() {
        return result;
    }

    public String getError() {
        return error;
    }

    public boolean isError() {
        return !StringUtils.isEmpty(error);
    }

    public Exception getException() {
        return e;
    }

    public static <T> YtResult<T> createResult(YtStatus status, T result) {
        return new YtResult<>(status, result, null, null);
    }

    public static <T> YtResult<T> createError(YtStatus status, String error, Exception e) {
        return new YtResult<>(status, null, error, e);
    }
}
