package ru.yandex.webmaster3.storage.util.yt;

import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum YtStatus implements IntEnum {
    UNKNOWN(-1),

    YT_200_OK(200),
    YT_202_SUCCESS(202),
    YT_307_REDIRECT_TO_PROXY(307),
    YT_400_FINISHED_WITH_ERROR(400),
    YT_401_UNAUTHORIZED(401),
    YT_404_UNKNOWN_ACTION(404),
    YT_405_WRONG_HTTP_METHOD(405),
    YT_406_WRONG_ACCEPT_FORMAT(406),
    YT_415_WRONG_ACCEPT_ENCODING_FORMAT(415),
    YT_429_TOO_MANY_REQUEST(429),
    YT_500_INTERNAL_PROXY_ERROR(500),
    YT_503_UNAVAILABLE_RETRY_LATER(503),;

    private final int value;

    YtStatus(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<YtStatus> R = IntEnumResolver.r(YtStatus.class);

    static YtStatus fromResponse(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        return YtStatus.R.fromValueOrUnknown(statusLine.getStatusCode());
    }
}
