package ru.yandex.webmaster3.storage.util.yt;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

/**
 * @author aherman
 */
public class YtTable extends YtNode {
    private final boolean sorted;
    private final List<String> sortedBy;
    private final long rowCount;
    private final long uncompressedDataSize;
    private final long compressedDataSize;
    private final YtSchema schema;

    public YtTable(YtPath path, NodeType nodeType, String id, String owner, DateTime creationTime, DateTime updateTime, boolean sorted,
                   List<String> sortedBy, long rowCount, long uncompressedDataSize, long compressedDataSize, YtSchema schema, JsonNode nodeMeta)
    {
        super(path, nodeType, id, owner,  creationTime, updateTime, nodeMeta);
        this.sorted = sorted;
        this.sortedBy = sortedBy;
        this.rowCount = rowCount;
        this.uncompressedDataSize = uncompressedDataSize;
        this.compressedDataSize = compressedDataSize;
        this.schema = schema;
    }

    public boolean isSorted() {
        return sorted;
    }

    public List<String> getSortedBy() {
        return sortedBy;
    }

    public long getRowCount() {
        return rowCount;
    }

    public long getUncompressedDataSize() {
        return uncompressedDataSize;
    }

    public long getCompressedDataSize() {
        return compressedDataSize;
    }

    @Nullable
    public YtSchema getSchema() {
        return schema;
    }

    @Override
    public String toString() {
        return getPath() + " id=" + getId() + " rc=" + rowCount + " size=" + uncompressedDataSize;
    }
}
