package ru.yandex.webmaster3.storage.util.yt;


import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Preconditions;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author avhaliullin
 */
public class YtVanillaCommand extends AbstractYtJob {
    private final Map<String, YtJobSpec> tasks;

    YtVanillaCommand(String ytCluster, List<YtPath> outputTables, Map<String, Object> secureVault, Map<String, Object> spec,
                     Map<String, YtJobSpec> tasks) {
        super("start_op", ytCluster, Collections.emptyList(), outputTables, secureVault, spec);
        this.tasks = tasks;
    }

    @Override
    protected UriComponentsBuilder createUri(URI proxyUri) {
        return super.createUri(proxyUri).queryParam("operation_type", "vanilla");
    }

    @Override
    protected void fillSpec(Map<String, Object> spec) {
        super.fillSpec(spec);
        spec.put("tasks", tasks);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder extends AbstractYtJobBuilder<Builder> {
        private final Map<String, YtJobSpec> tasks = new HashMap<>();

        @Override
        protected Builder getSelf() {
            return this;
        }

        public Builder addTask(String name, YtJobSpec spec) {
            tasks.put(name, spec);
            return this;
        }

        public YtVanillaCommand build() {
            Preconditions.checkState(!tasks.isEmpty());
            return new YtVanillaCommand(ytCluster, outputTables, secureVault, spec, tasks);
        }
    }
}
