package ru.yandex.webmaster3.storage.util.yt;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHeaders;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.FileEntity;
import org.springframework.web.util.UriComponentsBuilder;

import java.io.File;
import java.net.URI;

/**
 * @author aherman
 */
public class YtWriteTableCommand extends YtCommandImpl.PutCommand<Void> {
    private final YtPath path;
    private final File cachedTableFile;
    private final boolean append;

    public YtWriteTableCommand(YtPath path, File cachedTableFile, boolean append) {
        this.path = path;
        this.cachedTableFile = cachedTableFile;
        this.append = append;
    }

    @Override
    protected UriComponentsBuilder createUri(URI proxyUri) {
        StringBuilder pathString = new StringBuilder();
        if (append) {
            pathString.append("<append=true>");
        }
        pathString.append(path.toYtPath());
        return UriComponentsBuilder.fromUri(proxyUri)
                .path(API_V3 + "/write_table")
                .queryParam(PARAMETER_PATH, pathString.toString());
    }

    @Override
    protected void addHeaders(HttpPut request) {
        super.addHeaders(request);
        request.setHeader(HttpHeaders.CONTENT_TYPE, "application/x-yt-yson-binary");
        request.setHeader(HttpHeaders.CONTENT_ENCODING, "gzip");
    }

    @Override
    protected HttpEntity createRequestBody() {
        return new FileEntity(cachedTableFile);
    }

    @Override
    public boolean needHeavyProxy() {
        return true;
    }
}
