package ru.yandex.webmaster3.storage.util.yt.operation;

import java.net.URI;

import lombok.Value;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.webmaster3.storage.util.yt.YtCommandException;
import ru.yandex.webmaster3.storage.util.yt.YtCommandImpl;
import ru.yandex.webmaster3.storage.util.yt.YtOperationId;
import ru.yandex.webmaster3.storage.util.yt.YtResult;
import ru.yandex.webmaster3.storage.util.yt.YtStatus;

/**
 * @author aherman
 */
@Value
public class YtCompleteOperationCommand extends YtCommandImpl.PostCommand<Void> {

    YtOperationId operationId;

    @Override
    public UriComponentsBuilder createUri(URI proxyUri) {
        UriComponentsBuilder url = UriComponentsBuilder.fromUri(proxyUri).path(API_V3 + "/complete_op")
                .queryParam("operation_id", operationId.getId());
        return url;
    }

    @Override
    public boolean needHeavyProxy() {
        return false;
    }

    @Override
    protected YtResult<Void> onSuccess(YtStatus status, HttpResponse httpResponse) throws YtCommandException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return YtResult.createError(status, "Response is empty", null);
        }
        return YtResult.createResult(status, null);
    }

    @Override
    public String toString() {
        return "COMPLETE_OP " + operationId.toString();
    }
}
