package ru.yandex.webmaster3.storage.util.yt.transfer;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 23/10/2020.
 */
@Value
@Builder
public class ClickhouseCopyToolSettings {

    @JsonProperty("yt_task_state")
    YtTaskState ytTaskState;
    @JsonProperty("preprocessing")
    Preprocessing preprocessing;
    @JsonProperty("clickhouse_tables")
    ClickhouseTables clickhouseTables;
    @JsonProperty("clickhouse_client")
    ClickhouseClient clickhouseClient;
    @JsonProperty("shard_uploader")
    ShardUploader shardUploader;

    @Value
    @Builder
    public static final class YtTaskState {
        @JsonProperty("tasks_base_path")
        String tasksBasePath;
        @JsonProperty("account")
        String account;
        @JsonProperty("ttl")
        Long ttl;
        @JsonProperty("remove_on_completion")
        Boolean removeOnCompletion;
    }

    @Value
    @Builder
    public static final class Preprocessing {
        @JsonProperty("yt_pool")
        String ytPool;
        @JsonProperty("partitions_per_shard")
        Long partitionsPerShard;
        @JsonProperty("block_format")
        String blockFormat;
        @JsonProperty("block_compression_level")
        Long blockCompressionLevel;
        @JsonProperty("preprocessed_data_replication_factor")
        Long preprocessedDataReplicationFactor;
        @JsonProperty("data_size_per_job")
        Long dataSizePerJob;
        @JsonProperty("enable_job_splitting")
        Boolean enableJobSplitting;
        @JsonProperty("desired_block_size")
        Long desiredBlockSize;
        @JsonProperty("desired_compressed_block_size")
        Long desiredCompressedBlockSize;
        @JsonProperty("shuffle_shards")
        Boolean shuffleShards;
        @JsonProperty("treat_missing_columns_as_nulls")
        Boolean treatMissingColumnsAsNulls;
    }

    @Value
    @Builder
    public static final class ClickhouseTables {
        @JsonProperty("zookeeper_base_path")
        String zookeeperBasePath;
    }

    @Value
    @Builder
    public static final class ClickhouseClient {
        @JsonProperty("per_shard_quorum")
        String perShardQuorum;
        @JsonProperty("retriable_errors")
        List<Integer> retriableErrors;
        @JsonProperty("use_cluster_ddl")
        Boolean useClusterDdl;
        @JsonProperty("cluster_command_timeouts")
        ClusterCommandTimeouts clusterCommandTimeouts;
    }

    @Value
    @Builder
    public static final class ClusterCommandTimeouts {
        @JsonProperty("ping_hosts")
        Long pingHosts;
        @JsonProperty("discover_cluster")
        Long discoverCluster;
        @JsonProperty("discover_table")
        Long discoverTable;
        @JsonProperty("create_table")
        Long createTable;
    }

    @Value
    @Builder
    public static final class ShardUploader {
        @JsonProperty("threads_per_host")
        Long threadsPerHost;
        @JsonProperty("commit_batch_size")
        Long commitBatchSize;
        @JsonProperty("insert_block_timeout")
        Long insertBlockTimeout;
        @JsonProperty("too_many_parts_pause")
        Long tooManyPartsPause;
        @JsonProperty("max_too_many_parts_pause")
        Long maxTooManyPartsPause;
        @JsonProperty("too_many_parts_backoff_factor")
        Double tooManyPartsBackoffFactor;
        @JsonProperty("lock_shard_timeout")
        Long lockShardTimeout;
        @JsonProperty("ping_session_freq")
        Long pingSessionFre;
        @JsonProperty("job_executor")
        ShardUploaderJobExecutor jobExecutor;
        @JsonProperty("insert_block_sleep_time")
        Long insertBlockSleepTime;
    }

    @Value
    @Builder
    public static final class ShardUploaderJobExecutor {
        @JsonProperty("type")
        String type;
        @JsonProperty("yt")
        ShardUploaderJobExecutorYt yt;
    }

    @Value
    @Builder
    public static final class ShardUploaderJobExecutorYt {
        @JsonProperty("clusterName")
        String clusterName;
        @JsonProperty("pool")
        String pool;
        @JsonProperty("job_memory_limit")
        Long jobMemoryLimit;
        @JsonProperty("stderr_yt_path")
        String stderrYtPath;
        @JsonProperty("scheduling_tag_filter")
        String schedulingTagFilter;
    }

}
