package ru.yandex.webmaster3.storage.util.yt.transfer;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.webmaster3.storage.util.yt.YtPath;

/**
 * Created by Oleg Bazdyrev on 27/08/2018.
 */
@Value
@Builder
@AllArgsConstructor
public class YtTransferManagerAddTaskCommand {

    @JsonProperty("source_cluster")
    String sourceCluster;
    @JsonProperty("source_table")
    String sourceTable;
    @JsonProperty("destination_cluster")
    String targetCluster;
    @JsonProperty("destination_table")
    String targetTable;
    @JsonProperty("mdb_auth")
    MdbAuth mdbAuth;
    @JsonProperty("mdb_cluster_address")
    MdbClusterAddress mdbClusterAddress;
    @JsonProperty("clickhouse_credentials")
    ClickhouseCredentials clickhouseCredentials;
    @JsonProperty("clickhouse_copy_options")
    ClickhouseCopyOptions clickhouseCopyOptions;
    @JsonProperty("clickhouse_copy_tool_settings_patch")
    ClickhouseCopyToolSettings clickhouseCopyToolSettingsPatch;

    public static YtTransferManagerAddTaskCommand create(YtPath source, YtPath target) {
        return YtTransferManagerAddTaskCommand.builder()
                .sourceCluster(source.getCluster())
                .sourceTable(source.getPathWithoutCluster())
                .targetCluster(target.getCluster())
                .targetTable(target.getPathWithoutCluster())
                .build();
    }

    @Value
    @Builder
    public static final class MdbAuth {
        @JsonProperty("oauth_token")
        String oauthToken;
    }

    @Value
    @Builder
    public static final class MdbClusterAddress {
        @JsonProperty("cluster_id")
        String clusterId;
    }

    @Value
    @Builder
    public static final class ClickhouseCredentials {
        @JsonProperty("user")
        String user;
        @JsonProperty("password")
        String password;
    }

    @Value
    @Builder
    public static final class ClickhouseCopyOptions {
        @JsonProperty("command")
        ClickhouseCopyCommand command;
        @JsonProperty("primary_key")
        String primaryKey;
        @JsonProperty("sharding_key")
        String shardingKey;
        @JsonProperty("date")
        String date;
        @JsonProperty("date_column")
        String dateColumn;
        @JsonProperty("read_schema")
        String readSchema;
        @JsonProperty("reset_state")
        Boolean resetState;
    }

    public enum ClickhouseCopyCommand {
        @JsonProperty("create")
        CREATE,
        @JsonProperty("append")
        APPEND
    }
}
