package ru.yandex.webmaster3.storage.util.yt.transfer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;
import org.joda.time.DateTime;

/**
 * Created by Oleg Bazdyrev on 27/08/2018.
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@JsonIgnoreProperties(ignoreUnknown = true)
public class YtTransferTaskInfo {

    @JsonProperty("id")
    String id;
    @JsonProperty("source_cluster")
    String sourceCluster;
    @JsonProperty("source_table")
    String sourceTable;
    @JsonProperty("destination_cluster")
    String targetCluster;
    @JsonProperty("destination_table")
    String targetTable;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'")
    @JsonProperty("creation_time")
    DateTime creationTime;
    @JsonProperty("state_description")
    String stateDescription;
    @JsonProperty("execution_log")
    String executionLog;
    @JsonProperty("error")
    YtTransferTaskError error;
    @JsonProperty("state")
    YtTransferTaskState state;
    @JsonProperty("user")
    String user;

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class YtTransferTaskError {
        @JsonProperty("code")
        int code;
        @JsonProperty("message")
        String message;
        @JsonProperty("attributes")
        YtTransferTaskErrorAttributes attributes;
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class YtTransferTaskErrorAttributes {
        @JsonProperty("details")
        String details;
    }

}
