package ru.yandex.webmaster3.storage.verification;

import java.util.Optional;
import java.util.UUID;

import lombok.Setter;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.IUserHostVerifier;
import ru.yandex.webmaster3.core.host.verification.VerificationCausedBy;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.AutoVerificationCancelledFailInfo;
import ru.yandex.webmaster3.storage.verification.auto.AutoVerificationYDao;

/**
 * @author avhaliullin
 */
public class AutoVerifier implements IUserHostVerifier {
    @Setter
    private AutoVerificationYDao autoVerificationYDao;

    @Override
    public Optional<VerificationFailInfo> verify(long userId, WebmasterHostId hostId, UUID recordId,
                                                 long verificationUin, VerificationCausedBy verificationCausedBy) {
        if (autoVerificationYDao.hasRecord(userId, hostId)) {
            return Optional.empty();
        } else {
            return Optional.of(new AutoVerificationCancelledFailInfo());
        }
    }

    @Override
    public boolean isApplicable(WebmasterHostId hostId, long userId) {
        return true;
    }
}
