package ru.yandex.webmaster3.storage.verification;

import java.util.Optional;
import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.IUserHostVerifier;
import ru.yandex.webmaster3.core.host.verification.VerificationCausedBy;
import ru.yandex.webmaster3.core.host.verification.VerificationFailInfo;
import ru.yandex.webmaster3.core.host.verification.fail.FakeVerificationCancelled;

@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("fakeVerifier")
@Slf4j
public class FakeVerifier implements IUserHostVerifier {

    @Value("${webmaster3.storage.yndxRobotWebmasterVrfr.id}")
    private long yndxRobotFakeVerification;

    @Override
    public Optional<VerificationFailInfo> verify(long userId, WebmasterHostId hostId, UUID recordId, long verificationUin, VerificationCausedBy verificationCausedBy) {
        if (userId == yndxRobotFakeVerification) {
            log.error("Try fake verification for user_id -- {}", userId);
            return Optional.empty();
        }
        return Optional.of(new FakeVerificationCancelled());
    }

    @Override
    public boolean isApplicable(WebmasterHostId hostId, long userId) {
        return userId == yndxRobotFakeVerification;
    }
}
